// Rating
function rating()
{
	var $container = $('#rating'), $stars = $('a.star', $container), rating = true, stars = $('a.star.active', $container).size(), $favourite = $('a.favourite', $container);
	
	if(!$favourite.size())
	{
		$stars.addClass('disabled');
		
		return;
	}
	
	$container.mouseleave(function()
	{
		rating = true;
	});
	
	$stars.mouseover(function()
	{
		var $this = $(this);
		
		if(rating)
		{
			$stars.removeClass('active');
			
			$this.addClass('hover');
			
			$('a.star:lt('+$this.index()+')', $container).addClass('hover');
		}
	});
	
	$stars.mouseleave(function()
	{
		var $this = $(this);
		
		if(rating)
		{
			$('a.star:lt('+stars+')', $container).addClass('active');
			
			$this.removeClass('hover');
			
			$('a.star:lt('+$this.index()+')', $container).removeClass('hover');
		}
	});
	
	$stars.click(function()
	{
		var $this = $(this);
		
		if(rating)
		{
			rating = false;
			
			$('a.star.user', $container).removeClass('user');
			
			$this.addClass('user');
			$stars.removeClass('hover');
			
			$.ajax(rate_path,
			{
				'type': 'POST',
				'data': {'stars': $this.index() + 1},
				'dataType': 'json',
				'success': function(new_rating)
				{
					if(profile)
					{
						$('#user_rating').html(Math.round(new_rating*10)/10);
					}
					
					stars = Math.round(new_rating);
					
					$('a.star:lt('+stars+')', $container).addClass('active');
				}
			});
		}
	});
	
	var $info_favourites = $('#profile_favourites');
	
	$favourite.click(function()
	{
		if($favourite.hasClass('add'))
		{
			if(!profile)
			{
				$info_favourites.html(parseInt($info_favourites.html()) + 1);
			}
			
			$favourite.addClass('remove').removeClass('add');
		} else
		{
			if(!profile)
			{
				$info_favourites.html(parseInt($info_favourites.html()) - 1);
			}
			
			$favourite.addClass('add').removeClass('remove');
		}
		
		$.post(favourite_path);
	});
}

// Comments
function comments()
{
	var $submit = $('#comment_submit'), $write = $('#comment_write'), $container = $('#comments_container'), $textarea = $('#comment_message textarea'), $comments = $('#comments>table'), placeholder = true, placeholder_text = $textarea.val(), editing = 0;
	
	$textarea.focus(function()
	{
		if(placeholder)
		{
			$textarea.val('');
		}
	});
	
	$textarea.blur(function()
	{
		if($textarea.val() == '')
		{
			placeholder = true;
			
			$textarea.val(placeholder_text);
		}
	});
	
	$textarea.bind('keyup change', function()
	{
		if($textarea.val() == '')
		{
			$('#comment_submit_container').hide();
		} else
		{
			placeholder = false;
			
			$('#comment_submit_container').show();
		}
	});
	
	var html = function(row)
	{
		var $row = $('#comment-new').clone(true);
		
		$row.attr('id', 'comment-'+row.id).addClass('comment');
		
		$('.comment-new-profile', $row).attr('href', row.profile);
		$('.comment-new-avatar', $row).attr('src', row.avatar);
		$('.comment-new-profile', $row).replaceWith(row.user);
		$('.comment-new-ts', $row).addClass('time_ago').attr('timestamp', row.ts).html(row.ago);
		$('.comment-new-msg', $row).html(row.msg);
		
		if(!row.p_edit)
		{
			$('a.action.edit', $row).remove();
		}
		
		if(!row.p_delete)
		{
			$('a.action.delete', $row).remove();
		}
		
		return $row;
	};
	
	var $info_comments = $('#profile_comments');
	
	$('form[name=comment]').submit(function(e)
	{
		e.preventDefault();
		
		if(!$submit.hasClass('disabled'))
		{
			$info_comments.html(parseInt($info_comments.html()) + 1);
			
			$write.slideUp();
			
			if($container.css('display') === 'none')
			{
				$container.slideDown();
			}
			
			var $top = $('tr.comment', $comments);
			
			$.ajax(comment_path,
			{
				'type': 'POST',
				'dataType': 'json',
				'data':
				{
					'action': 'new',
					'id': $top.size()?$top.eq(0).attr('id').split('-')[1]:0,
					'message': $textarea.val(),
					'edit':	editing
				},
				'success': function(response)
				{
					var i;
					
					for(i=0; i<response.length; i++)
					{
						$(html(response[i])).prependTo($comments);
					}
				}
			});
		}
	});
	
	$('tr', $comments).hover(function()
	{
		$('a.action', $(this)).show();
	}, function()
	{
		$('a.action', $(this)).hide();
	});
	
	$('a.action.edit', $comments).click(function()
	{
		$write.show();
		
		var $row = $(this).parents().eq(2);
		
		editing = $row.attr('id').split('-')[1];
		
		$row.remove();
	});
	
	$('a.action.delete', $comments).click(function()
	{
		var $row = $(this).parents().eq(2);
		
		$.post(comment_path,
		{
			'action': 'delete',
			'id': $row.attr('id').split('-')[1]
		}, function()
		{
			$row.remove();
			
			var size = $('tr.comment', $comments).size();
			
			if(size == 1)
			{
				$('#comments_more').click();
			} else if(size == 0)
			{
				$container.hide();
			}
		});
	});
}

// Referer
function referer()
{
	$('#referer').click(function()
	{
		$(this).select();
	});
}

// Ready
$(function()
{
	rating();
	comments();
	referer();
});